SET SQL_SAFE_UPDATES=0;

SET @recipientDataProviderId=(select recipientDataProviderId from msg_recipient_type where code='APPLICANT_INSPCTN_DOC_ADHOC');

UPDATE `sql_dtprovider`
SET `sqlQuery` ="SELECT 
     ard.`id` AS ID,
     T5.`firstName` AS FIRST_NAME,
     T5.`middleName` AS MIDDLE_NAME,
     T5.`lastName` AS LAST_NAME,
     T5.`emailId` AS EMAIL_ID,
     T5.`mobileNumber` AS MOBILE_NO,
     T5.`mobileCountryCode` AS MOBILE_CODE,
     dt.itemValue AS DOCUMENT_NAME,
     DATE_FORMAT(doc.submissionDate, '%d-%m-%Y') AS SUBMISSION_DATE,
     T4.printName AS INSPECTION_BY,
     DATE_FORMAT(ed.inspectionDate, '%d-%m-%Y') AS INSPECTION_DATE,
     DATE_FORMAT(ed.returnedDate, '%d-%m-%Y') AS RETURNED_DATE,
     retrnby.printName AS RETURNED_BY,
     ed.documentNote AS NOTE,
     ed.remark AS REMARK,
     b.printName AS BATCH,
     prg.programNameToBePrint AS PROG_PRINT_NAME,
     T12.academyName AS ACADEMY_NAME,
     T12.locationName AS LOCATION_NAME,
     T12.displayName AS ACADEMY_NAME_LOCATION,
CONCAT(T14.phoneCountryCode,'-',T14.phoneAreaCode,'-',T14.phoneNo) AS CAMPUS_PHONE_NO,
    T14.primaryeEmailId AS CAMPUS_EMAILID,
    T14.websiteURL AS CAMPUS_WEBSITE_URL,
    (CASE
         WHEN
             T12.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T12.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (Case 
         when 
             T12.footerUrl is not null 
                 and org.orgUrl IS NOT NULL 
         then 
             CONCAT(org.orgUrl, '/', T12.footerUrl)
         else NULL 
     end) as FOOTER_URL,
     CONCAT(UCASE(LEFT(ard.status, 1)), LCASE(SUBSTRING(ard.status, 2))) AS STATUS
 FROM
     application_required_documents ard
         LEFT JOIN
     application T1 ON T1.id = ard.applicationId
         LEFT JOIN
     document_types dt ON dt.id = ard.documentTypeId
         LEFT JOIN
     documents doc ON doc.id = ard.documentId
         LEFT JOIN
     extended_documents ed ON ed.documentId = doc.id
         LEFT JOIN
     users T2 ON ed.inspectionDoneBy = T2.id
         LEFT JOIN
     staffs T3 ON T2.id = T3.userId
         LEFT JOIN
     persons T4 ON T3.personId = T4.id
         LEFT JOIN
     applicant_person T5 ON T5.id = T1.applicantPersonId
         LEFT JOIN
     users retrnby ON ed.returnedBy = retrnby.id
         LEFT JOIN
     program_selection_process psp ON psp.id = ard.programSelectionProcessId
         LEFT JOIN
     prog_batch_seat_config pbsc ON pbsc.id = psp.programBatchSeatConfigId
         LEFT JOIN
     batches b ON b.id = pbsc.programBatchId
         LEFT JOIN
     programs prg ON prg.id = b.programId
         LEFT JOIN
     academy_location T12 ON T12.id = prg.academyLocationId
      LEFT JOIN
    academy_location_addresses T13 ON T13.academyLocationId = T12.id
    LEFT JOIN
    address T14 ON T14.id = T13.addressId AND T14.addressTypeId = 10
LEFT OUTER JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations)
 WHERE
     ard.id IN (namedParams)",
     `jsonString` ='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "itemValue",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "SUBMISSION_DATE",
            "resultKey": "SUBMISSION_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "INSPECTION_BY",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "INSPECTION_DATE",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "RETURNED_DATE",
            "resultKey": "RETURNED_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "RETURNED_BY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "documentNote",
            "resultKey": "NOTE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "remark",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "programNameToBePrint",
            "resultKey": "PROG_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "campusPhoneNo",
            "resultKey": "CAMPUS_PHONE_NO",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "campusEmailId",
            "resultKey": "CAMPUS_EMAILID",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "campusWebsiteUrl",
            "resultKey": "CAMPUS_WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 21
        }

    ]}' WHERE (`dataProviderId` = @recipientDataProviderId);
SET SQL_SAFE_UPDATES=1;
